"use strict";


/**
 * Object for encapsulation of sensor config
 */
function SensorConfig(){  
	var self = this;


	this._data = {

		/**
		 * @type {int}
		 */
		threshold : null,

		/**
		 * @type {number}
		 */
		mode : null,

		/**
		 * @type {number}
		 */
		activeLines : { from: 20, to: 2028},

	};

	this.setThreshold = function (value) {
		this._data.threshold = parseInt(value);
	};

	this.setMode = function (value) {
		this._data.mode = parseInt(value);
	};

	this.setActiveLines = function (value) {
		this._data.activeLines = value;
	};


	// ---------------------------------
	// getters
	
	this.getThreshold = function () {
		return this._data.threshold;
	};

	this.getMode = function () {
		return this._data.mode;
	};

	this.getActiveLines = function () {
		return this._data.activeLines;
	};


};


//exposure
module.exports = SensorConfig;