"use strict";

var GlobalConstants = require('../../constants/GlobalConstants');

/**
 * Object for encapsulation of one command message - encapsulates all necessary properties
 */
function Message(){  
	var self = this;

	/**
	 * Command name
	 * @type {string}
	 */
	this._name = null;

	/**
	 * Param tag - tagging messages
	 * @type {number}
	 */
	this._tag = null;


	/**
	 * Blocking
	 * @type {bool}
	 */
	this._blocking = null;

	/**
	 * Response
	 * @type {RespConnMessage}
	 */
	this._connRespMessage = null;

	/**
	 * Response
	 * @type {RespConnMessage}
	 */
	this._connReqMessage = null;


	/**
	 * Response size
	 * @type {Date}
	 */
	this._startTime = null;
	this._endTime = null;

	/**
	 * Metadata to pass with message when it's returned
	 * @type {object}
	 */
	this._metaData = null;

	/**
	 * Promise methods to call if promise was made
	 * @type {object}
	 */
	this._promiseResolver = null;
	this._promiseRejecter = null;
	
	
	this.setName = function(nameToSet){
		this._name = nameToSet;
	};
	this.getName = function(){
		return this._name;
	};


	this.setTag = function(tag){
		this._tag = tag;
	};
	this.getTag = function(){
		return this._tag;
	};


	this.setMetaData = function(dataToSet){
		this._metaData = dataToSet;
	};
	this.getMetaData = function(){
		return this._metaData;
	};

	this.setConnRespMessage = function(msg){
		this._connRespMessage = msg;
	};
	this.getConnRespMessage = function(){
		return this._connRespMessage;
	};

	this.setConnReqMessage = function(msg){
		this._connReqMessage = msg;
	};
	this.getConnReqMessage = function(){
		return this._connReqMessage;
	};
	


	this.setBlocking = function(blockingToSet){
		this._blocking = blockingToSet;
	};
	this.getBlocking = function(){
		return this._blocking;
	};
	this.isBlocking = function(){
		return this.getBlocking();
	};


	this.setStartTime = function(value){
		this._startTime = value;
	};
	this.getStartTime = function(){
		return this._startTime;
	};

	this.setEndTime = function(value){
		this._endTime = value;
	};
	this.getEndTime = function(){
		return this._endTime;
	};

	this.getExecutionTime = function(){
		if (!this._startTime || !this._endTime){
			return;
		}

		return this._endTime - this._startTime;
	};

	this.setPromiseResolver = function(resolver){
		this._promiseResolver = resolver;
	};
	this.getPromiseResolver = function(){
		return this._promiseResolver;
	};

	this.setPromiseRejecter = function(rejecter){
		this._promiseRejecter = rejecter;
	};
	this.getPromiseRejecter = function(){
		return this._promiseRejecter;
	};


	this.toLog = function() {
		var msg = 'name :' + this._name;
		msg += '\ntag :' + this._tag;
		msg += '\ndata :' + this._data;
		msg += '\nblocking :' + this._blocking;
		msg += '\nrespConnMessage :' + this._connRespMessage;
		msg += '\nstartTime :' + this._startTime;
		msg += '\nendTime :' + this._endTime;

		return msg;
	};
};

//exposure
module.exports = Message;