"use strict";

var GlobalConstants = require('../../constants/GlobalConstants');

/**
 * Object for encapsulation of one command message - encapsulates all necessary properties
 */
function ConnRespMessage(){  
	var self = this;

	/**
	 * Result
	 * @type {number}
	 */
	this._responseCode = null;

	/**
	 * Param checksum
	 * @type {number}
	 */
	this._checkSum = null;

	/**
	 * Param tag - tagging messages
	 * @type {number}
	 */
	this._tag = null;

	/**
	 * Response size
	 * @type {int}
	 */
	this._responseSize = null;	

	/**
	 * Data to send
	 * @type {Buffer}
	 */
	this._data = null;


	this.setResponseCode = function(responseCodeToSet){
		this._responseCode = responseCodeToSet;
	};
	this.getResponseCode = function(){
		return this._responseCode;
	};

	this.setCheckSum = function(checkSum){
		this._checkSum = checkSum;
	};
	this.getCheckSum = function(){
		return this._checkSum;
	};

	this.setTag = function(tag){
		this._tag = tag;
	};
	this.getTag = function(){
		return this._tag;
	};

	this.setResponseSize = function(responseSizeToSet){
		this._responseSize = responseSizeToSet;
	};
	this.getResponseSize = function(){
		return this._responseSize;
	};

	this.setData = function(dataToSet){
		this._data = dataToSet;
	};
	this.getData = function(){
		return this._data;
	};



	this.toLog = function() {
		var msg = '\responseCode :' + this._responseCode;
		msg += '\ncheckSum :' + this._checkSum;
		msg += '\ntag :' + this._tag;
		msg += '\nresponseSize :' + this._responseSize;
		msg += '\ndata :' + this._data;

		return msg;
	};
};


ConnRespMessage.RESPONSE_OK = 1;
ConnRespMessage.RESPONSE_BADARG = 2;
ConnRespMessage.RESPONSE_BADADR = 3;
ConnRespMessage.RESPONSE_RDONLY = 4;
ConnRespMessage.RESPONSE_TOOBIG = 5;
ConnRespMessage.RESPONSE_SAMPLE = 10;
ConnRespMessage.RESPONSE_LAST = 11;


//exposure
module.exports = ConnRespMessage;