"use strict";

var GlobalConstants = require('../../constants/GlobalConstants');

/**
 * Object for encapsulation of one command message - encapsulates all necessary properties
 */
function ConnReqMessage(){  
	var self = this;

	/**
	 * Code command
	 * @type {number}
	 */
	this._commandCode = null;

	/**
	 * Param checksum
	 * @type {number}
	 */
	this._checkSum = null;

	/**
	 * Param tag - tagging messages
	 * @type {number}
	 */
	this._tag = null;
	
	/**
	 * Param address
	 * @type {number}
	 */
	this._address = null;

	/**
	 * Data to send
	 * @type {Buffer}
	 */
	this._data = null;

	

	this.setCommandCode = function(commandCodeToSet){
		this._commandCode = commandCodeToSet;
	};
	this.getCommandCode = function(){
		return this._commandCode;
	};

	this.setCheckSum = function(checkSum){
		this._checkSum = checkSum;
	};
	this.getCheckSum = function(){
		return this._checkSum;
	};

	this.setTag = function(tag){
		this._tag = tag;
	};
	this.getTag = function(){
		return this._tag;
	};

	this.setAddress = function(address){
		this._address = address;
	};
	this.getAddress = function(){
		return this._address;
	};

	this.setData = function(dataToSet){
		this._data = dataToSet;
	};
	this.getData = function(){
		return this._data;
	};

	this.toLog = function() {
		var msg = 'commandCode :' + this._commandCode;
		msg += '\ncheckSum :' + this._checkSum;
		msg += '\ntag :' + this._tag;
		msg += '\naddress :' + this._address;
		msg += '\ndata :' + this._data;

		return msg;
	};
};

ConnReqMessage.COMMAND_SYNC = 1;
ConnReqMessage.COMMAND_WRITE = 2;
ConnReqMessage.COMMAND_READ = 3;


//exposure
module.exports = ConnReqMessage;