"use strict";

var Message = require('./message.js');  
var ConnReqMessage = require('./connReqMessage.js');  
var paramsList = require('./paramsSet.js')

function CommandSet(){  

	var commands = {
		get1Data                     : { 'name' : 'get1Data',                     'code' : ConnReqMessage.COMMAND_READ,  'address' : 0x1000, 'block' : false, 'length' : 6},
		getProfile                   : { 'name' : 'getProfile',                   'code' : ConnReqMessage.COMMAND_READ,  'address' : 0x8000, 'block' : false, 'length' : 2092},
		getProfileNormalized         : { 'name' : 'getProfileNormalized',         'code' : ConnReqMessage.COMMAND_READ,  'address' : 0x9000, 'block' : false, 'length' : 2040},
		getProfileNormalizedFiltered : { 'name' : 'getProfileNormalizedFiltered', 'code' : ConnReqMessage.COMMAND_READ,  'address' : 0xa000, 'block' : false, 'length' : 2040},
		getMode                      : { 'name' : 'setMode',                      'code' : ConnReqMessage.COMMAND_READ,  'address' : 0x000D, 'block' : true, 'length' : 1},
		getThreshold                 : { 'name' : 'getThreshold',                 'code' : ConnReqMessage.COMMAND_READ,  'address' : 0x2000, 'block' : true, 'length' : 2},
		getLaserPower                : { 'name' : 'getLaserPower',                'code' : ConnReqMessage.COMMAND_READ,  'address' : 0x2005, 'block' : true, 'length' : 1},
		getActiveLines               : { 'name' : 'getActiveLines',               'code' : ConnReqMessage.COMMAND_READ,  'address' : 0x2001, 'block' : true, 'length' : 2},
		getVersion                   : { 'name' : 'getVersion',                   'code' : ConnReqMessage.COMMAND_READ,  'address' : 0x200,  'block' : true, 'length' : 6},
		isObject                     : { 'name' : 'isObject',                     'code' : ConnReqMessage.COMMAND_READ,  'address' : 0x1100, 'block' : true, 'length' : 1},
		tableGetCount                : { 'name' : 'tableGetCount',                'code' : ConnReqMessage.COMMAND_READ,  'address' : 0x1200, 'block' : true, 'length' : 1},
		tableGetItems                : { 'name' : 'tableGetItems',                'code' : ConnReqMessage.COMMAND_READ,  'address' : 0x1203, 'block' : true, 'length' : null},

		tableSaveItem                : { 'name' : 'tableSaveItem',                'code' : ConnReqMessage.COMMAND_WRITE, 'address' : 0x000E, 'block' : true},
		tableDeleteItem              : { 'name' : 'tableDeleteItem',              'code' : ConnReqMessage.COMMAND_WRITE, 'address' : 0x000F, 'block' : true},
		tableDeleteAll               : { 'name' : 'tableDeleteAll',               'code' : ConnReqMessage.COMMAND_WRITE, 'address' : 0x000F, 'block' : true},

		ramToFlash                   : { 'name' : 'ramToFlash',                   'code' : ConnReqMessage.COMMAND_WRITE,  'address' : 0x0100, 'block' : true},
		flashToRam                   : { 'name' : 'flashToRam',                   'code' : ConnReqMessage.COMMAND_WRITE,  'address' : 0x0101, 'block' : true},
		
		setMode                      : { 'name' : 'setMode',                      'code' : ConnReqMessage.COMMAND_WRITE, 'address' : 0x000D, 'block' : true},
		setThreshold                 : { 'name' : 'setThreshold',                 'code' : ConnReqMessage.COMMAND_WRITE, 'address' : 0x2000, 'block' : true},
		setLaserPower                : { 'name' : 'setLaserPower',                'code' : ConnReqMessage.COMMAND_WRITE, 'address' : 0x2005, 'block' : true},

		setLaserOn                   : { 'name' : 'setLaserOn',                   'code' : ConnReqMessage.COMMAND_WRITE, 'address' : 0x000A, 'block' : true},
		setLaserOff                  : { 'name' : 'setLaserOff',                  'code' : ConnReqMessage.COMMAND_WRITE, 'address' : 0x000A, 'block' : true},


		normalize                    : { 'name' : 'normalize',                    'code' : ConnReqMessage.COMMAND_WRITE, 'address' : 0x000B, 'block' : true},
		normalizationSourceUser      : { 'name' : 'normalizationSourceUser',      'code' : ConnReqMessage.COMMAND_WRITE, 'address' : 0x0012, 'block' : true},

		powerOff                     : { 'name' : 'powerOff',                     'code' : ConnReqMessage.COMMAND_WRITE, 'address' : 0x0013, 'block' : true},
	};


	/**
	 * Access to commands by command name
	 */
	this.get = function(name, data){
		var message = new Message();
		var connReqMessage = new ConnReqMessage();
		message.setConnReqMessage(connReqMessage);

		switch (name){
			//standard sensor commands - sends only command, no data
			case 'get1Data':
			case 'getProfile':
			case 'getProfileNormalized':
			case 'getProfileNormalizedFiltered':
			case 'getThreshold':
			case 'getMode':
			case 'getLaserPower':
			case 'getVersion':
			case 'getActiveLines':
			case 'isObject':
			case 'tableGetCount':
			case 'tableGetItems':
				var command = commands[name];
				message.setName(name);
				message.setBlocking(command.block);
				connReqMessage.setCommandCode(command.code);
				connReqMessage.setAddress(command.address);

				connReqMessage.setData(command.length);
				break;

			case 'setMode':
			case 'setThreshold':
			case 'setLaserPower':
			case 'tableDeleteItem':
				var command = commands[name];
				message.setName(name);
				message.setBlocking(command.block);
				connReqMessage.setCommandCode(command.code);
				connReqMessage.setAddress(command.address);
				connReqMessage.setData(data.value);
				break;

			case 'setLaserOn':
			case 'tableDeleteAll':
				var command = commands[name];
				message.setName(name);
				message.setBlocking(command.block);
				connReqMessage.setCommandCode(command.code);
				connReqMessage.setAddress(command.address);
				connReqMessage.setData(0x0);
				break;


			case 'normalize':
			case 'ramToFlash':
			case 'flashToRam':
			case 'setLaserOff':
			case 'tableSaveItem':
			case 'powerOff':
			case 'normalizationSourceUser':
				var command = commands[name];
				message.setName(name);
				message.setBlocking(command.block);
				connReqMessage.setCommandCode(command.code);
				connReqMessage.setAddress(command.address);
				connReqMessage.setData(0x1);
				break;


			//two params in to bytes
			//mmap mode/avg not implemented in sensor
			// case 'setModeAndAveraging':
			// 	var paramName = name.replace('set', '');
			// 	var param = paramsList[paramName];

			// 	var command = commands['setParam'];
			// 	var dataToSend = new Uint8Array(2); //alway send two bytes
			// 	dataToSend[0] = dataSecondByte;
			// 	dataToSend[1] = data;

			// 	message.setName(name);
			// 	message.setCommandCode(command.code);
			// 	message.setBlocking(command.block);
			// 	message.setResponseSize(command.resLen);
			// 	message.setData(dataToSend);
			// 	message.setCommandToSend(prepareCommand(command.code, EEPROM_PARAMS_ADDR + param.addr));

			// 	break;


				// var command = commands[name];
				// message.setName(name);
				// message.setCommandCode(command.code);
				// message.setBlocking(command.block);
				// message.setResponseSize(command.resLen);
				// message.setCommandToSend(prepareCommand(command.code | (data & 0xF)));
				// break;

			
			default:
				throw "Support for this command not added yet: " + name;
		}
		//console.log('preparedCommand', message);
		
		return message;
	};

};

//expose
module.exports = CommandSet;
