"use strict";

var assign = require('object-assign');
var util = require('util');
var EventEmitter = require('events').EventEmitter;
var GlobalConstants = require('../constants/GlobalConstants');


util.inherits(BaseCanvas, EventEmitter);


function BaseCanvas(domNode) {
	EventEmitter.call(this);

	//canvas dom node
	this._canvasDomNode = domNode;

	//own paper js scope
	this._paperScope = new paper.PaperScope();
	this._paperScope.settings.handleSize = GlobalConstants.PAPERJS_SEL_BOX_SIZE;
	this._paperScope.setup(this._canvasDomNode);
	
	//base resolution for which we calculate roi, windows etc., multiply with sizeRatio for coordinates in current size
	this.TARGET_WIDTH = parseInt(domNode.getAttribute('data-target-width'));
	this.TARGET_HEIGHT = parseInt(domNode.getAttribute('data-target-height'));

	//size of the view
	this.VIEW_WIDTH = this._paperScope.view.viewSize.width;
	this.VIEW_HEIGHT = this._paperScope.view.viewSize.height;

	//orig size ratio
	this._sizeRatio = 1;

	//list of paper js elements
	this._elements = {};

	//resize handler to recalculate ration and refresh
	// this._paperScope.view.onResize = function(event) {
	// 	// this._paperScope.view.setViewSize(
	// 	// 	new paper.Size(
	// 	// 		this._toRealSize(this.TARGET_WIDTH), 
	// 	// 		this._toRealSize(this.TARGET_HEIGHT)
	// 	// 	)
	// 	// );
 //        this.refresh();
	// 	console.log(this._elements, this._paperScope.view);
 //    }.bind(this);

};

BaseCanvas.prototype._resizeView = function(w, h){
	this.VIEW_WIDTH = w;
	this.VIEW_HEIGHT = h;
	this._paperScope.view.setViewSize(new paper.Size(w, h));
    this._sizeRatio = this._canvasDomNode.offsetWidth / this.TARGET_WIDTH;

};

BaseCanvas.prototype._toRealSize = function(val){
	return val * this._sizeRatio;
};

BaseCanvas.prototype._toTargetSize = function(val){
	return val / this._sizeRatio;
};


module.exports = BaseCanvas;
