"use strict";

var fs = nw.require('fs');
var UnitsConverter = require('../helpers/UnitsConverter');
var ConnectionTypeConstants = require('../constants/ConnectionTypeConstants');



var data = {

	/**
	 * @type {int}
	 */
	units : UnitsConverter.MILLIMETERS,

	connectionType : ConnectionTypeConstants.SERIAL,

	/**
	 * IP address
	 * @type {String}
	 */
	ip : '192.168.0.16',

	/**
	 * Port number
	 * @type {Number}
	 */
	port : 1024,


	/**
	 * Port number
	 * @type {Number}
	 */
	comPort : 'COM13',


};


/**
 * Object for encapsulation of app config
 */
var AppConfig = {  

	setUnits : function (value) {
		if (UnitsConverter.validateUnits(value)) {
			data.units = value;
		}
	},

	setIp : function (value) {
		data.ip = value;
	},

	setPort : function (value) {
		data.port = value;
	},

	setComPort : function (value) {
		data.comPort = value;
	},

	setConnectionType : function (connType) {
		if (connType in ConnectionTypeConstants) {
			data.connectionType = connType;			
		}else{
			throw 'Trying to set nonexistent connection type to App Config';
		}
	},

	
	// ---------------------------------
	// getters
	
	getUnits : function () {
		return data.units;
	},

	getIp : function () {
		return data.ip;
	},

	getPort : function () {
		return data.port;
	},

	getComPort : function () {
		return data.comPort;
	},

	getConnectionType : function () {
		return data.connectionType;
	},

	toXml : function(filename) {
		var XMLWriter = require('xml-writer');
		var xw = new XMLWriter(true);


		xw.startDocument();
		xw.startElement('root');
		for(var item in data){
			if (data.hasOwnProperty(item)) {
				switch (item) {
					case 'displayedPoints' :
						xw.writeElement(item, JSON.stringify(data[item]));
						break;
					default :
						xw.writeElement(item, (typeof data[item] == 'undefined') ? '' : data[item]);
						break;
				}
			}
		}
		xw.endDocument();

		fs.writeFile(filename, xw.toString(), function(err) {
		    if(err) {
		        throw err;
		    }

		    return true;
		}); 
	},

	fromXml : function(filename) {
		var XMLReader = require('xmlreader');

		try {
			var xmlContent = fs.readFileSync(filename, 'utf8');
		} catch (err) {
			throw err;
		}

		XMLReader.read(xmlContent, function (err, res){
			if (err) {
				throw err;
			}

			for(var item in data){
				if (data.hasOwnProperty(item)) {
					if (res.root[item]){
						switch (item) {
							case 'displayedPoints' :
								data[item] = JSON.parse(res.root[item].text());
								break;
							default :
								data[item] = res.root[item].text();
								break;
						}
					}
				}
			}
			
		});
		
	}
	
};


//exposure
module.exports = AppConfig;