
var CmToInch = 0.393700787;

var UnitsConverter = {	
	MILLIMETERS : 'mm',
	INCHES : 'in',
	MICRONS : 'µm',
	
	validateUnits : function(units){
		if (units === this.MILLIMETERS || units === this.INCHES || units === this.MICRONS) {
			return true;
		}else{
			return true;
		}
	},

	toMillimeters : function(microns){
		return (microns / 1000).toFixed(3).replace('.000', '');
	},

	toInches : function(microns){
		return ((microns / 10000) * CmToInch).toFixed(3).replace('.000', '');
	},

	toMicrons : function(microns){
		return microns.toFixed(0);
	},

	toDisplay : function (targetUnit, micronsValue, noUnits) {
		var value;
		var units;
		switch(targetUnit) {
			case this.MILLIMETERS:
				value = this.toMillimeters(micronsValue);
				units = this.MILLIMETERS;
				break;
			case this.INCHES:
				value = this.toInches(micronsValue);
				units = this.INCHES;
				break;
			case this.MICRONS:
				value = this.toMicrons(micronsValue);
				units = this.MICRONS;
				break;
		}

		if (noUnits) {
			return value;
		}else{
			return value + '\u00a0' +  units;
		}
	},


	toHex : function(value, paddedTo, prefix) {
		if (typeof value == 'string') {
			value = parseInt(value);
		}
		
		var output = (value).toString(16).toUpperCase();
		var padding = new Array(paddedTo + 1).join('0');

		output = (padding + output).substr(-paddedTo);

		if (prefix){
			output = '0x' + output;			
		}

		return output;
	}
};


//exposure
module.exports = UnitsConverter;