
var IMAGES_DIRECTORY = 'images/';
var PROFILES_DIRECTORY = 'profiles/';
var CLONES_DIRECTORY = 'clones/';
var DATAS_DIRECTORY = 'data_tables/';
var TEMPLATES_DIRECTORY = 'templates/';

var FilenameGenerator = {

	image : function(extension, nameSuffix){
		var nameParts = [
			'image'
		];

		if (nameSuffix) {
			nameParts.push(nameSuffix);
		}

		nameParts.push(this.timestamp());

		return IMAGES_DIRECTORY + nameParts.join('_') + '.' + extension.toLowerCase();
	},

	profile : function(extension, nameSuffix){
		var nameParts = [
			'profile'
		];

		if (nameSuffix) {
			nameParts.push(nameSuffix);
		}

		nameParts.push(this.timestamp());

		return PROFILES_DIRECTORY + nameParts.join('_') + '.' + extension.toLowerCase();
	},

	dataTable : function(extension, nameSuffix){
		var nameParts = [
			'data'
		];

		if (nameSuffix) {
			nameParts.push(nameSuffix);
		}

		nameParts.push(this.timestamp());

		return DATAS_DIRECTORY + nameParts.join('_') + '.' + extension.toLowerCase();
	},

	screenshot : function(extension, nameSuffix){
		var nameParts = [
			'screenshot'
		];

		if (nameSuffix) {
			nameParts.push(nameSuffix);
		}

		nameParts.push(this.timestamp());

		return IMAGES_DIRECTORY + nameParts.join('_') + '.' + extension.toLowerCase();
	},

	firmware : function(extension, nameSuffix){
		var nameParts = [
			'firmware'
		];

		if (nameSuffix) {
			nameParts.push(nameSuffix);
		}

		nameParts.push(this.timestamp());

		return CLONES_DIRECTORY + nameParts.join('_') + '.' + extension.toLowerCase();
	},

	templateProfile : function(extension, nameSuffix){
		var nameParts = [
			'template_profile'
		];

		if (nameSuffix) {
			nameParts.push(nameSuffix);
		}

		nameParts.push(this.timestamp());

		return TEMPLATES_DIRECTORY + nameParts.join('_') + '.' + extension.toLowerCase();
	},

	templateImage : function(extension, nameSuffix){
		var nameParts = [
			'template_image'
		];

		if (nameSuffix) {
			nameParts.push(nameSuffix);
		}

		nameParts.push(this.timestamp());

		return TEMPLATES_DIRECTORY + nameParts.join('_') + '.' + extension.toLowerCase();
	},

	eeprom : function(extension, nameSuffix){
		var nameParts = [
			'eeprom'
		];

		if (nameSuffix) {
			nameParts.push(nameSuffix);
		}

		nameParts.push(this.timestamp());

		return CLONES_DIRECTORY + nameParts.join('_') + '.' + extension.toLowerCase();
	},

	timestamp : function() {
		var date = new Date();

		var year = date.getFullYear();
		var day = "0" + date.getDate();
		var month = "0" + (date.getMonth() + 1);

		var hours = "0" + date.getHours();
		var minutes = "0" + date.getMinutes();
		var seconds = "0" + date.getSeconds();
		var milliseconds = "000" + date.getMilliseconds();

		var formattedDate = year + '-' + month.substr(-2) + '-' + day.substr(-2);
		var formattedTime = hours.substr(-2) + '-' + minutes.substr(-2) + '-' + seconds.substr(-2) + '-' + milliseconds.substr(-4);

		return formattedDate + '_' + formattedTime;
	}
};


//exposure
module.exports = FilenameGenerator;