
var FileSelector = {

	selectFile : function(extension, callback){
		var input = document.createElement('input');
		input.setAttribute('type', 'file');
		input.setAttribute('accept', '.' + extension);
		input.setAttribute('style', 'display:none!important');

		input.addEventListener(
			'change',
			function(event){
				console.log(event);
				var file = event.target.files[0] ? event.target.files[0] : null;

				if (file) {
					callback(file.path);					
				}

				//remove from body
				document.body.removeChild(input);
			},
			false
		);

		input.click();

		//if not put in body or referenced, it doesn't work
		//probably cause GC will trash it
		document.body.appendChild(input);
	},

	selectFileWithConfirm : function(extension, confirmMessage, callback){
		var self = this;
		var input = document.createElement('input');
		input.setAttribute('type', 'file');
		input.setAttribute('accept', '.' + extension);
		input.setAttribute('style', 'display:none!important');

		input.addEventListener(
			'change',
			function(event){
				var file = event.target.files[0] ? event.target.files[0] : null;
				
				//wrapper function for adding parameter to callback call
				var alertifyCallback = function() {
					callback(path);
				};

				if (file) {
					var filename = file.name;
					var path = file.path;

					alertify.confirm(
						confirmMessage + ' ' + filename,
						alertifyCallback
					);
				}

				//remove from body
				document.body.removeChild(input);
			},
			false
		);

		input.click();

		//if not put in body or referenced, it doesn't work
		//probably cause GC will trash it
		document.body.appendChild(input);
	}
};


//exposure
module.exports = FileSelector;