/**
 * 
 * Grayscale 8bpp bitmap encoding - based on bmp-js (@author shaozilee)
 * 
 */

var Buffer = nw.require('buffer').Buffer;

function BmpEncoder(){
	this.flag = "BM";
	this.headerInfoSize = 40;
	this.reserved = 0;
	this.planes = 1;
	this.bitPP = 8;
	this.compress = 0;
	this.hr = 0;
	this.vr = 0;
	this.colors = 256;
	this.importantColors = 0;	
};

BmpEncoder.prototype.encode = function(imgData) {
	this.buffer = imgData.data;
	this.width = imgData.width;
	this.height = imgData.height;
	this.extraBytes = this.width % 4;
	this.rgbSize = this.height * (this.width + this.extraBytes);
	this.offset = this.headerInfoSize + 14 + 256 * 4; //bmp info header + bmp file header + palette
	this.fileSize = this.rgbSize + this.offset;

	var resBuffer = Buffer.alloc(this.offset + this.rgbSize, 'binary');
	var position = 0;

	//bitmap file header
	resBuffer.write(this.flag, position,2); position+=2;
	resBuffer.writeUInt32LE(this.fileSize, position); position+=4;
	resBuffer.writeUInt32LE(this.reserved, position); position+=4;
	resBuffer.writeUInt32LE(this.offset, position); position+=4;

	//bitmap info header
	resBuffer.writeUInt32LE(this.headerInfoSize, position); position+=4;
	resBuffer.writeUInt32LE(this.width, position); position+=4;
	resBuffer.writeUInt32LE(this.height, position); position+=4;
	resBuffer.writeUInt16LE(this.planes, position); position+=2;
	resBuffer.writeUInt16LE(this.bitPP, position); position+=2;
	resBuffer.writeUInt32LE(this.compress, position); position+=4;
	resBuffer.writeUInt32LE(this.rgbSize, position); position+=4;
	resBuffer.writeUInt32LE(this.hr, position); position+=4;
	resBuffer.writeUInt32LE(this.vr, position); position+=4;
	resBuffer.writeUInt32LE(this.colors, position); position+=4;
	resBuffer.writeUInt32LE(this.importantColors, position); position+=4;

	//color palette
	for (var i = 0; i < 256; i++){
		resBuffer[position + i * 4] = i;
		resBuffer[position + i * 4 + 1] = i;
		resBuffer[position + i * 4 + 2] = i;
		resBuffer[position + i * 4 + 3] = 0;
	}
	position += 256 * 4;


	//data bytes
	var sourceIndex = 0;
	var rowBytes = this.width + this.extraBytes;
	for (var y = this.height - 1; y >= 0; y--){
		for (var x = 0; x < this.width; x++){
			var resTargetInde =  position+y*rowBytes+x;
			resBuffer[resTargetInde] = this.buffer[sourceIndex++];			
		}
		//padding to four bytes
		if (this.extraBytes > 0){
			var fillOffset = position + y * rowBytes + this.width;
			resBuffer.fill(0, fillOffset, fillOffset + this.extraBytes);	
		}
	}

	return resBuffer;
};




module.exports = BmpEncoder;
