

var React = require('react');
var SensorStore = require('../stores/SensorStore');
var SensorActions = require('../actions/SensorActions');
var GlobalConstants = require('../constants/GlobalConstants');
var classNames = require('classnames');

var VolatileParameters = React.createClass({
	propTypes : {
		getSensorConfig : React.PropTypes.func.isRequired
	},

	getInitialState: function() {
		return {

		}
	},

	componentDidMount: function() {

	},

	componentWillUnmount: function() {

	},

	_loadParameters : function(){
		SensorActions.getSensorParams();
		alertify.success('Parameters were loaded');
	},
	
	_saveParameters : function() {
		//config not in prop = config is invalid
		var sensorConfig = this.props.getSensorConfig();
		if (!sensorConfig){
			alertify.error('Some parameters are invalid');
			return;
		}
		
		SensorActions.modeChange(sensorConfig.getMode());
		SensorActions.thresholdChange(sensorConfig.getThreshold());
		//mode changed using command
		//mmap mode/avg not implemented in sensor
		//SensorActions.averagingWindowChange(sensorConfig.getAveragingWindow());

		alertify.success('Parameters were set');
	},

	render: function() {		
		return (
			<div className='ui buttons volatile-parameters' >
				<div
					className='ui button'
					onClick={this._loadParameters}
					>
					Load
				</div>
				<div
					className='ui button'
					onClick={this._saveParameters}
					>
					Save
				</div>
			</div>
	    );
	}

});

module.exports = VolatileParameters;
