

var React = require('react');
var SensorStore = require('../stores/SensorStore');
var AppStore = require('../stores/AppStore');

var VersionInfo = React.createClass({
	getInitialState: function() {
		return {
			fwVersion : ''
		};
	},

	componentDidMount: function() {
		SensorStore.addFwVersionListener(this._fwVersionWasReadHandler);
	},

	componentWillUnmount: function() {
		SensorStore.removeFwVersionListener(this._fwVersionWasReadHandler);
	},

	_fwVersionWasReadHandler : function (data) {
		this.setState({
			fwVersion : data
		});
	},

	render: function() {
		var pcbString = '';
		var fwString = '';
		if (this.state.fwVersion) {
			pcbString = "v" + this.state.fwVersion.hwRevision;
			fwString = "r"+ this.state.fwVersion.svnRevision;
		}
		return (
			<div>
				<h3>
					Version info
				</h3>
				<strong>
					PCB version: {pcbString} <br />
					FW version: {fwString} <br />
					SW version: {AppStore.VERSION}
				</strong>
			</div>
	    );
	}

});

module.exports = VersionInfo;