

var React = require('react');
var SensorActions = require('../actions/SensorActions');
var SensorStore = require('../stores/SensorStore');
var UnitsConverter = require('../helpers/UnitsConverter');
var AppConfig = require('../objects/AppConfig');

var unitsList = {};

unitsList[UnitsConverter.MILLIMETERS] = 'Millimeters';
unitsList[UnitsConverter.INCHES]      = 'Inches';
unitsList[UnitsConverter.MICRONS]     = 'Microns';


var UnitsButtonSwitcher = React.createClass({

	getInitialState: function() {
		return {
			currentUnits : AppConfig.getUnits()
		}
	},

	componentDidMount : function() {
		//SensorStore.addConfigChangedListener(this._configChangedHandler);
	},

	componentWillUnmount : function() {
		//SensorStore.removeConfigChangedListener(this._configChangedHandler);
	},

	/**
	 * Event handler for 'change' events coming from the TodoStore
	 */
	_onUnitsChangeHandler : function() {
		var newUnits;

		switch (this.state.currentUnits) {
			case UnitsConverter.MILLIMETERS :
				newUnits = UnitsConverter.INCHES;
				break;
			case UnitsConverter.INCHES :
				newUnits = UnitsConverter.MICRONS;
				break;
			case UnitsConverter.MICRONS :
				newUnits = UnitsConverter.MILLIMETERS;
				break;
		}

		this.setState({
			currentUnits : newUnits
		});

		AppConfig.setUnits(newUnits);
	},


	// _configChangedHandler : function(config){
	// 	this.setState({
	// 		currentUnits : parseInt(config.getUnits())
	// 	});
	// },


	/**
	 * @return {object}
	 */
	render: function() {
		return (
			<div
				ref="unitsButton"
				className="ui fluid button"
				onClick={this._onUnitsChangeHandler}
			>
				{unitsList[this.state.currentUnits]}
			</div>
		);
	}


});

module.exports = UnitsButtonSwitcher;
