
var React = require('react');
var ReactDOM = require('react-dom');
var SensorStore = require('../stores/SensorStore');
var AppActions = require('../actions/AppActions');
var SensorActions = require('../actions/SensorActions');
var TabConstants = require('../constants/TabConstants');
var SensorTypeConstants = require('../constants/SensorTypeConstants');

var MeasureTab = require('./MeasureTab.jsx');
var ProfileTab = require('./ProfileTab.jsx');
var StreamTab = require('./StreamTab.jsx');
var SensorTab = require('./SensorTab.jsx');
var SamplingTableTab = require('./SamplingTableTab.jsx');

var DEFAULT_TAB = TabConstants.SENSOR;

var _selectedTabName = DEFAULT_TAB;
var _selectedTabPane = null;
var _selectedTabContent = null;

var Tabs = React.createClass({
	getInitialState() {
	    return {
	        
	    };
	},

	componentDidMount: function() {
		SensorStore.addSensorConnectedListener(this._connectedHandler);
		SensorStore.addSensorDisconnectedListener(this._disconnectedHandler);
	},

	componentWillUnmount: function() {
		SensorStore.removeSensorConnectedListener(this._connectedHandler);	
		SensorStore.removeSensorDisconnectedListener(this._disconnectedHandler);	
	},

	_onTabPaneClick: function(event){
		if (event.currentTarget.classList.contains('disabled')) return;

		var targetTabPane = event.currentTarget;
		var targetTabName = event.currentTarget.getAttribute('data-tab');
		var targetTabContent = document.querySelector('.tab[data-tab=' + targetTabName + ']');

		var currentTabPane = document.querySelector('a[data-tab=' + _selectedTabName + ']');
		var currentTabContent = document.querySelector('.tab[data-tab=' + _selectedTabName + ']');

		currentTabPane.classList.remove('active');
		currentTabContent.classList.remove('active');

		targetTabPane.classList.add('active');
		targetTabContent.classList.add('active');

		_selectedTabName = targetTabName;

		AppActions.tabChange(_selectedTabName);
	},

	_connectedHandler : function (connectionInfo) {
		this.allowTabs(connectionInfo);
	},

	_disconnectedHandler : function () {
		this.resetTabs();
	},


	allowTabs: function (connectionInfo) {
		var tabs = ReactDOM.findDOMNode(this.refs.tabPanes);
		var selector = '.disable-when-disconnected';
		var tabsToAllow = Array.prototype.slice.call(tabs.querySelectorAll(selector));

		// filter tabs depending on connection type - monitor/backup fw
		// if monitor and backup together - show info message
		if (connectionInfo.isBackupFirmware && connectionInfo.isMonitorConnection) {
			alertify.error('Backup firmware loaded and connected as monitor. Use active connection and upload firmware');
			tabsToAllow = [];
		}else if (connectionInfo.isBackupFirmware) {
			//backup - allow only sensor and cloning
			alertify.error('Backup firmware loaded');

			tabsToAllow = tabsToAllow.filter(function (value) {
				return (value.getAttribute('data-tab') == TabConstants.SETTINGS) ||	(value.getAttribute('data-tab') == TabConstants.SENSOR);
			});
		}else if (connectionInfo.isMonitorConnection) {
			//allow all but settings
			tabsToAllow = tabsToAllow.filter(function (value) {
				return value.getAttribute('data-tab') !== TabConstants.SETTINGS;
			});
		}
		
		for (var i = 0; i < tabsToAllow.length; i++) {
			tabsToAllow[i].classList.remove('disabled');
		};
	},

	resetTabs: function () {
		var tabs = ReactDOM.findDOMNode(this.refs.tabPanes);
		var settingsPane = tabs.querySelector('[data-tab=' + DEFAULT_TAB + ']');
			settingsPane.click();

		var tabsToDisable = tabs.querySelectorAll('.disable-when-disconnected');
		for (var i = 0; i < tabsToDisable.length; i++) {
			tabsToDisable[i].classList.add('disabled');
		};
	},

	render: function() {
		return (
			<div className="container">
				<div className="ui top attached tabular menu" ref="tabPanes">
					<a data-tab={TabConstants.MEASURE} className="disabled item disable-when-disconnected" onClick={this._onTabPaneClick}>
						<i className="resize horizontal icon"></i>Measure
					</a>
					<a data-tab={TabConstants.PROFILE} className="disabled item disable-when-disconnected" onClick={this._onTabPaneClick}>
						<i className="line chart icon"></i>Profile
					</a>
					<a data-tab={TabConstants.SAMPLING_TABLE} className="disabled item disable-when-disconnected" onClick={this._onTabPaneClick}>
						<i className="table icon"></i>Data table
					</a>
					{/*<a data-tab={TabConstants.STREAM} className="disabled item disable-when-disconnected" onClick={this._onTabPaneClick}>
						<i className="line chart icon"></i>Stream
					</a>*/}

					<a data-tab={TabConstants.SENSOR} className="active item" onClick={this._onTabPaneClick}>
						<i className="sign in icon"></i>Sensor
					</a>
					
				</div>


				<div className="ui bottom attached tab segment" data-tab={TabConstants.MEASURE}>
					<MeasureTab />
				</div>

				<div className="ui bottom attached tab segment" data-tab={TabConstants.PROFILE}>
					<ProfileTab />
				</div>

				<div className="ui bottom attached tab segment" data-tab={TabConstants.SAMPLING_TABLE}>
					<SamplingTableTab />
				</div>

				{/*<div className="ui bottom attached tab segment" data-tab={TabConstants.STREAM}>
					<StreamTab />
				</div>*/}

				<div className="active ui bottom attached tab segment" data-tab={TabConstants.SENSOR}>
					<SensorTab />
				</div>
			</div>
	    );
	}

});

module.exports = Tabs;