

var React = require('react');
var SensorParams = require('./SensorParams.jsx');
var Eeprom = require('./Eeprom.jsx');
var UnitsButtonSwitcher = require('./UnitsButtonSwitcher.jsx');
var VolatileParameters = require('./VolatileParameters.jsx');
var VersionInfo = require('./VersionInfo.jsx');
var Connection = require('./Connection.jsx');
var SensorActions = require('../actions/SensorActions');
var SensorStore = require('../stores/SensorStore');
var ConnectionTypeConstants = require('../constants/ConnectionTypeConstants');
var AppConfig = require('../objects/AppConfig');
var classNames = require('classnames');
var ping = nw.require('ping');

var REF_SENSOR_PARAMS = 'sensorParams';
var REF_CONNECTION = 'connection';


var SensorTab = React.createClass({
	getInitialState: function() {
		return {
			sensorParams : null,
			portsList : [],

			connected : false,
			// isBackupFirmware : false,
		};
	},

	componentDidMount: function() {
		SensorStore.addSensorConnectedListener(this._connectedChangedHandler);
		SensorStore.addSensorDisconnectedListener(this._disconnectedChangedHandler);
	},

	componentWillUnmount: function() {
		SensorStore.removeSensorConnectedListener(this._connectedChangedHandler);
		SensorStore.removeSensorDisconnectedListener(this._disconnectedChangedHandler);
	},

	_connectedChangedHandler : function (connectionInfo) {
		this.setState({
			connected : true,
			// isBackupFirmware : connectionInfo.isBackupFirmware
		});	
	},

	_disconnectedChangedHandler : function () {
		this.setState({
			connected : false,
			// isBackupFirmware : false
		});	
	},

	/**
	 * Preselect searched result - argument iether IP address or ConnectionTypeCOnstants.USB
	 */
	_searchedSensorSelected : function (searchResult) {
		if (searchResult == ConnectionTypeConstants.USB) {
			this.refs[REF_CONNECTION].setConnectionType(ConnectionTypeConstants.USB);
		}else{
			this.refs[REF_CONNECTION].setConnectionType(ConnectionTypeConstants.ETHERNET);
			this.refs[REF_CONNECTION].setIp(searchResult);
		}
	},


	render: function() {
		return (
			<div className="ui grid">
				<div className="row">
					<div className="twelve wide column">
						<Connection ref={REF_CONNECTION} />
					</div>
					<div className="four wide column">
						<h3>Units</h3>
						<div className="ui fluid form">
							<div className="field">
								<UnitsButtonSwitcher />
							</div>
						</div>
					</div>
				</div>

				{/*this.state.connected ? 
					<div className="row">
						<div className="sixteen wide column">
							<h5>FLASH memory</h5>
							<Eeprom  />
						</div>
					</div>
					:
					''
				*/}

				{this.state.connected ? 
					<div className="row">
						<div className="sixteen wide column">
							<VersionInfo />
						</div>
					</div>
					:
					''
				}

				
			</div>
	    );
	}

});

module.exports = SensorTab;