
var fs = nw.require('fs');
var React = require('react');
var Moment = require('moment')
var SensorActions = require('../actions/SensorActions');
var SensorStore = require('../stores/SensorStore');
var UnitsConverter = require('../helpers/UnitsConverter');
var FilenameGenerator = require('../helpers/FilenameGenerator');
var classNames = require('classnames');
var AppConfig = require('../objects/AppConfig');

// timer for continuous updating measuredValue in state - avoid fast flickering rerendering of value
var measuredValueUpdateTimer;

var SamplingTableTab = React.createClass({
	REFRESH_INTERVAL : 50,

	measResultAllModes : 0,

	getInitialState: function() {
		return {
			sensorParams : null,
			tableItems : []
		};
	},

	componentDidMount: function() {
		SensorStore.addConfigChangedListener(this._configChangedHandler);
		SensorStore.addMeasureDataReceivedListener(this._dataReceived);
		SensorStore.addTableItemsReceivedListener(this._tableReceived);
		// SensorStore.addSensorDisconnectedListener(this._disconnectedChangedHandler);
		
		//timer to update measured value - avoid fast flickering
		measuredValueUpdateTimer = setInterval(function () {
			if (!this.state.pause){
				this.setState({
					measuredValue : this.measResultAllModes[this.state.mode] ? this.measResultAllModes[this.state.mode] : 0
				});
			}
		}.bind(this), this.REFRESH_INTERVAL);
	},

	componentWillUnmount: function() {
		SensorStore.removeConfigChangedListener(this._configChangedHandler);
		SensorStore.removeMeasureDataReceivedListener(this._dataReceived);
		SensorStore.removeTableItemsReceivedListener(this._tableReceived);
		// SensorStore.removeSensorDisconnectedListener(this._disconnectedChangedHandler);
		
		clearInterval(measuredValueUpdateTimer);
	},

	_configChangedHandler : function(config){
		if (typeof config.getMode() === 'number'){
			this.setState({
				mode : parseInt(config.getMode())
			});
		}
	},

	// update class property, state is updated slower with timer
	_dataReceived : function (data) {
		// console.log(data);
		
		this.measResultAllModes = data
	},

	_tableReceived : function (table) {
		this.setState({
			tableItems : table
		});
	},

	_saveFile : function (filename, data) {
		

		fs.writeFile(
			filename,
			data,
			'ascii',
			function(err) {
				if(err) {
					alertify.error('Couldn\'t save file');
				}else{
					alertify.success('File saved');
				}
			}
		);
	},

	_getTableCsv : function (data) {
		var lines = this.state.tableItems.map((item) => {
			return [
				UnitsConverter.toDisplay(AppConfig.getUnits(), item.value, true),
				Moment(item.time).format('YYYY-MM-DD HH:mm:ss')
			].join(',')
		});

		return lines.join(require('os').EOL)
	},

	_saveToCsv : function () {
		this._saveFile(
			FilenameGenerator.dataTable('csv'),
			this._getTableCsv()
		)
	},

	render: function() {
		let scrollerDivStyle = {
			width: this.state.tableItems.length > 13 ? '481px' : '480px',
			marginTop : '15px',
			overflowX : 'hidden',
			height:  '570px'
		};
		return (
			<div className="ui grid">
				<div className="row">
					<div className="sixteen wide column">
						<button className="ui small green button" onClick={() => {SensorActions.tableSaveItem()}}>
							Save
						</button>
						<button className="ui small red icon button" onClick={() => {SensorActions.tableDeleteAll()}}>
							<i className="remove icon" />Clear all
						</button>
						<button className="ui small icon button" onClick={this._saveToCsv}>
							<i className="save icon" />Export to CSV
						</button>
						<div style={scrollerDivStyle} >
							<table className="ui very compact table" style={{width: '460px', willChange: 'scroll-position'}} >
								<thead>
									<tr>
										
										<th style={{width: '45%'}}>Value</th>
										<th style={{width: '45%'}}>Time</th>
										<th ></th>
									</tr>
								</thead>
								<tbody>
									{this.state.tableItems.map((item, index) => {
										return (
											<tr key={index} >
												<td>
													{UnitsConverter.toDisplay(AppConfig.getUnits(), item.value)}
												</td>
												<td>
													{Moment(item.time).format('HH:mm:ss')}
												</td>
												<td>
													<button className="ui red mini icon button" onClick={() => {SensorActions.tableDeleteItem(index + 1)}}>
														<i className="remove icon" />
													</button>
												</td>
											</tr>
										);
									})}
									<tr className="current">
										<td>
											<i className="right caret icon" />
											<strong>{UnitsConverter.toDisplay(AppConfig.getUnits(), this.state.measuredValue)}</strong>
										</td>
										<td>
											<strong></strong>
										</td>
										<td></td>
									</tr>
								</tbody>
							</table>
						</div>
					</div>
				</div>				
			</div>
	    );
	}

});

module.exports = SamplingTableTab;