
var React = require('react');
var SensorStore = require('../stores/SensorStore');
var SensorActions = require('../actions/SensorActions');
var ModeButtonSwitcher = require('./ModeButtonSwitcher.jsx');
var ButtonsDivider = require('./ButtonsDivider.jsx');
var TabConstants = require('../constants/TabConstants');
var ImageSaver = require('./ImageSaver.jsx');
var UnitsConverter = require('../helpers/UnitsConverter');
var FileSelector = require('../helpers/FileSelector');
var AppConfig = require('../objects/AppConfig');
var Profile = require('./Profile.jsx');
var assign = require('object-assign');
var classNames = require('classnames');

// timer for continuous updating measuredValue in state - avoid fast flickering rerendering of value
var measuredValueUpdateTimer;


var REF_PROFILE = 'profile';

var ProfileTab = React.createClass({
	REFRESH_INTERVAL : 10,
	measResultAllModes : [],

	getInitialState : function(){
		return {
			measuredValue : 0,
			mode : 0,
			threshold : 0,

			zoom : false,
			profilePause : false,

			displayRawProfile : false,

			profileTemplate : false,
		};
	},

	componentDidMount: function() {
		SensorStore.addSensorConnectedListener(this._connectedChangedHandler);
		SensorStore.addSensorDisconnectedListener(this._disconnectedChangedHandler);
		SensorStore.addConfigChangedListener(this._configChangedHandler);
		SensorStore.addTabChangedListener(this._tabChangeHandler);
		SensorStore.addMeasureDataReceivedListener(this._dataReceived);

		measuredValueUpdateTimer = setInterval(function () {
			this.setState({
				measuredValue : this.measResultAllModes[this.state.mode] ? this.measResultAllModes[this.state.mode] : 0
			});
		}.bind(this), this.REFRESH_INTERVAL);

		//set default value
		if (this.state.displayRawProfile){
			this.refs[REF_PROFILE].showRawProfile();
		}else{
			this.refs[REF_PROFILE].hideRawProfile();
		}
	},

	componentWillUnmount: function() {
		SensorStore.removeSensorConnectedListener(this._connectedChangedHandler);
		SensorStore.removeSensorDisconnectedListener(this._disconnectedChangedHandler);
		SensorStore.removeConfigChangedListener(this._configChangedHandler);
		SensorStore.removeTabChangedListener(this._tabChangeHandler);
		SensorStore.removeMeasureDataReceivedListener(this._dataReceived);

		clearInterval(measuredValueUpdateTimer);
	},

	_connectedChangedHandler : function (connectionInfo) {
		this.setState({
			
		});	
	},

	_disconnectedChangedHandler : function () {
		this.setState({

		});	
	},

	_tabChangeHandler: function(tab){
		if (tab == TabConstants.PROFILE) {

		}
	},

	// update class property, state is updated with timer
	_dataReceived : function (data) {
		this.measResultAllModes = data
	},

	_onTresholdChange : function (event) {
		var value = parseInt(event.currentTarget.value);
		SensorActions.thresholdChange(value);
	},

	/**
	 * Something in sensor config was changed - update the state
	 * @param  {object} config Sensor configuration
	 */
	_configChangedHandler : function(config){
		let nextState = {};

		if (typeof config.getMode() == "number"){
			nextState['mode'] = config.getMode();
		}
		if (typeof config.getThreshold() == "number"){
			nextState['threshold'] = config.getThreshold();
		}

		this.setState(nextState);
	},

	_onZoomClick : function (event) {
		var newValue = !this.state.zoom;

		this.setState({
			zoom : newValue
		}, function () {
			this.refs[REF_PROFILE].switchZoom(newValue);
		});
	},

	_onZoomPlusClick : function (event) {
		if (this.state.zoom) {
			this.refs[REF_PROFILE].zoomPlus();
		}
	},

	_onZoomMinusClick : function (event) {
		if (this.state.zoom) {
			this.refs[REF_PROFILE].zoomMinus();
		}
	},


	_onProfilePauseClick : function (event) {
		this.setState({
			profilePause : !this.state.profilePause
		});	
	},

	_onTemplateToggle : function (event) {
		var newState = {};
		if (!this.state.profileTemplate) {
			this.refs[REF_PROFILE].setTemplate();
			newState.profileTemplate = true;
		}else{
			this.refs[REF_PROFILE].cancelTemplate();
			newState.profileTemplate = false;
		}

		this.setState(newState);
	},

	_onTemplateSave : function (event) {
		this.refs[REF_PROFILE].saveTemplate();
	},

	_onTemplateLoad : function (event) {
		var self = this;
		FileSelector.selectFile(
			'csv',
			function (path) {
				self.refs[REF_PROFILE].setTemplate(path);

				//independent on result of template loading operation
				//cause loading is asynchronic
				self.setState({
					profileTemplate : true
				});
			}
		);
	},

	_savePng : function () {
		this.refs[REF_PROFILE].savePng();
	},

	_saveCsv : function () {
		this.refs[REF_PROFILE].saveCsv();
	},

	_onDisplayRawChange : function (event) {
		this.setState({
			displayRawProfile : !this.state.displayRawProfile
		}, () => {
			if (this.state.displayRawProfile){
				this.refs[REF_PROFILE].showRawProfile();
			}else{
				this.refs[REF_PROFILE].hideRawProfile();
			}
		});
	},
	
	render: function() {
		
		var zoomButtonClasses = classNames(
			'ui small button',
			{
				'green' : this.state.zoom
			}
		);

		var zoomPlusMinusClasses = classNames(
			'ui small icon button',
			{
				'disabled' : !this.state.zoom
			}
		);

		var profilePauseButtonClasses = classNames(
			'ui small fluid labeled icon button',
			{
				'green' : this.state.profilePause
			}
		);
		var templateButtonClasses = classNames(
			'ui small button',
			{
				'green' : this.state.profileTemplate
			}
		);
		var displayRawButtonClasses = classNames(
			'ui small fluid button',
			{
				'green' : this.state.displayRawProfile
			}
		);
	
		return (
			<div className="ui grid">
				<div className="row">
					<div className="four wide column ui form side-panel">
						<div className="field ui segment">
							<div className="ui centered first header" style={{margin: '10px 0'}}>
								Result: {UnitsConverter.toDisplay(AppConfig.getUnits(), this.state.measuredValue)}
				        	</div>
			        	</div>
						<div className="field">
							<ModeButtonSwitcher />
						</div>
						{/*<div className="ui field">
							<label>
								Threshold [{this.state.threshold}]
							</label>
							<input
								className="ui input"
								onChange={this._onTresholdChange}
								value={this.state.threshold === null ? '' : this.state.threshold}
								disabled={this.props.disabled}
								type="range"
								min="1"
								max="2048"
							/>
						</div>*/}
						<div className="field">
							<div className="ui fluid button" onClick={function () {							
								SensorActions.normalize();
							}.bind(this)} >
								Normalize
							</div>
						</div>
						<div className="field text-center">
							<div className="ui buttons buttons-flex">
								<div
									ref="zoomBtn"
									type="button"
									className={zoomButtonClasses}
									onClick={this._onZoomClick}
								>
									Zoom
								</div>								
								<div
									type="button"
									className={zoomPlusMinusClasses}
									onClick={this._onZoomPlusClick}
								>
									<i className="plus icon" />
								</div>
								<div
									type="button"
									className={zoomPlusMinusClasses}
									onClick={this._onZoomMinusClick}
								>
									<i className="minus icon" />
								</div>
							</div>		
						</div>
						<div className="field">
							<div
								type="button"
								className={displayRawButtonClasses}
								onClick={this._onDisplayRawChange}
							>
								Display raw
							</div>
						</div>
						<div className="field">
							<div
								ref="pauseBtn"
								type="button"
								className={profilePauseButtonClasses}
								onClick={this._onProfilePauseClick}
							>
								<i className="pause icon" />Pause
							</div>
						</div>
						<div className="field text-center">
							<div className="ui buttons">
								<div
									type="button"
									className={templateButtonClasses}
									onClick={this._onTemplateToggle}
								>
									Template
								</div>
								<div
									type="button"
									className="ui icon button"
									onClick={this._onTemplateSave}
								>
									<i className="save icon" />
								</div>
								<div
									type="button"
									className="ui icon button"
									onClick={this._onTemplateLoad}
								>
									<i className="upload icon" />
								</div>
							</div>
						</div>
						{/*}
						<div className="field text-center">
							<div className="ui buttons buttons-flex">
								<div
									type="button"
									className={templateButtonClasses}
									onClick={this._onTemplateToggle}
								>
									Template
								</div>
								<div
									type="button"
									className="ui icon button"
									onClick={this._onTemplateSave}
								>
									<i className="save icon" />
								</div>
								<div
									type="button"
									className="ui icon button"
									onClick={this._onTemplateLoad}
								>
									<i className="upload icon" />
								</div>
							</div>
						</div>*/}
						<div className="field text-center">
							<ImageSaver 
									onSave1={this._savePng}
									onSave2={this._saveCsv}
									text1="PNG"
									text2="CSV"
								/>
						</div>
					</div>
					<div className="twelve wide column">
						<Profile ref={REF_PROFILE} pause={this.state.profilePause} onTresholdChange={this._onTresholdChange} />
					</div>
				</div>
			</div>
	    );
	}

});

module.exports = ProfileTab;