
var React = require('react');
var SensorActions = require('../actions/SensorActions');
var SensorStore = require('../stores/SensorStore');

var modesList = [
	'Mode 0 - Edge 1',
	'Mode 1 - Edge 2',
	'Mode 2 - Dia',
	'Mode 3 - Gap',
	'Mode 4 - Center',
	'Mode 5 - Solid edge'
];

var ModeButtonSwitcher = React.createClass({

	getInitialState: function() {
		return {
			currentMode : 0,
			disabled : false
		}
	},

	componentDidMount: function() {
		SensorStore.addConfigChangedListener(this._configChangedHandler);
		SensorStore.addSensorConnectedListener(this._connectedChangedHandler);
		SensorStore.addSensorDisconnectedListener(this._disconnectedChangedHandler);
	},

	componentWillUnmount: function() {
		SensorStore.removeConfigChangedListener(this._configChangedHandler);
		SensorStore.removeSensorConnectedListener(this._connectedChangedHandler);
		SensorStore.removeSensorDisconnectedListener(this._disconnectedChangedHandler);
	},

	_connectedChangedHandler : function (connectionInfo) {
		this.setState({
			disabled : (connectionInfo.isMonitorConnection) ? true : false
		});	
	},

	_disconnectedChangedHandler : function () {
		this.setState({
			disabled : true
		});	
	},

	_onModeChange: function(event) {
		var newMode = this.state.currentMode;
		if (event.type === 'click') {
			newMode++;		
		}else{
			newMode--;
		}
		if (newMode >= modesList.length) {
			newMode = 0;
		}else if (newMode < 0) {
			newMode = modesList.length - 1;
		}

		SensorActions.modeChange(newMode);
	},


	_configChangedHandler : function(config){
		if (typeof config.getMode() === 'number'){
			this.setState({
				currentMode : parseInt(config.getMode())
			});
		}
	},

	/**
	 * @return {object}
	 */
	render: function() {
		return (
			<button
				ref="modeButton"
				className="ui fluid button"
				onClick={this._onModeChange}
				onContextMenu={this._onModeChange}
				disabled={this.state.disabled}
			>
				{modesList[this.state.currentMode]}
			</button>
		);
	}


});

module.exports = ModeButtonSwitcher;
