
var fs = nw.require('fs');
var React = require('react');
var ReactDOM = require('react-dom');
var Tabs = require('./Tabs.jsx');
var SensorStore = require('../stores/SensorStore');
var AppStore = require('../stores/AppStore');
var FilenameGenerator = require('../helpers/FilenameGenerator');
var NOT_CONNECTED_TEXT = 'MicroStudio - not connected';
var CONNECTED_TEXT = 'Connected: ';

var APP_CONFIG_FILE = 'appconfig.xml';
var AppConfig = require('../objects/AppConfig');
try {
    AppConfig.fromXml(APP_CONFIG_FILE);
}catch (err){
	//console.log(err);
}

var gui = window.require('nw.gui');
    gui.App.registerGlobalHotKey(
    	new gui.Shortcut({
			key : "Ctrl+Shift+F12",
			active : function() {
				win.showDevTools();
			}
		})
	);
    gui.App.registerGlobalHotKey(
    	new gui.Shortcut({
			key : "Ctrl+Shift+S",
			active : function() {
				saveScreenshot();
			}
		})
	);

var win = gui.Window.get();
    // win.showDevTools();
    // win.moveBy(2000, 0);
    win.on('close', function () {
    	AppConfig.toXml(APP_CONFIG_FILE);
    	this.close(true);
    });

//fill version from NW.js manifest
AppStore.VERSION = gui.App.manifest.version;

var saveScreenshot = function () {
	var filename = FilenameGenerator.screenshot('png');

	win.capturePage(
		function(buffer){
			fs.writeFile(filename, buffer, 'ascii', function(err) {
					if(err) {
						alertify.error('Couldn\'t save image');
					}

					alertify.success('File saved');
				}
			);		
		},
		{ 
			format : 'png', 
			datatype : 'buffer'
		}
	);		
};

var MainApp = React.createClass({

	getInitialState: function() {
		return {

		}
	},

	componentDidMount: function() {
		SensorStore.addSensorConnectedListener(this._connectedChangedHandler);
		SensorStore.addSensorDisconnectedListener(this._disconnectedChangedHandler);

	},

	componentWillUnmount: function() {
		SensorStore.addSensorConnectedListener(this._connectedChangedHandler);
		SensorStore.addSensorDisconnectedListener(this._disconnectedChangedHandler);
	},

	_connectedChangedHandler : function(connectionInfo) {
		win.title = CONNECTED_TEXT + connectionInfo.text;
	},

	_disconnectedChangedHandler : function() {
		win.title = NOT_CONNECTED_TEXT;
	},

	_closeClick : function () {
		AppConfig.toXml(APP_CONFIG_FILE);
		win.close();
	},

	_fullscreenClick : function () {
		if (this.state.maximized) {
			win.unmaximize();
		}else{
			win.maximize();
		}
	},

	_minimizeClick : function () {
		win.minimize();
	},

	savePngImage : function () {
		var imageData = ReactDOM.findDOMNode(this.refs.image).toDataURL();

		//remove encoding string and decode data
		imageData = imageData.split(',')[1];
		imageData = atob(imageData);

		this._saveFile(
			FilenameGenerator.image('png'),
			imageData
		);	
	},

	/**
	 * @return {object}
	 */
	render: function() {
		//unused
		// var screenshotButton = 
		// 	<div
		// 		id="screenshot"
		// 		className="ui mini icon button"
		// 		onClick={this._saveScreenshot}
		// 		title="Save screenshot"
		// 	>
		// 		<i className="photo small icon"></i>
		// 	</div>;
		
		return (
			<div>				
				<Tabs />
			</div>
		);
	}

});

module.exports = MainApp;
