

var React = require('react');
var SensorStore = require('../stores/SensorStore');
var SensorActions = require('../actions/SensorActions');
var SensorConfig = require('./../objects/sensor/SensorConfig');
var classNames = require('classnames');
var debounce = require('debounce');

/**
 * reference for current sensor config
 */
var currentConfig;
var expectedEepromWrittenBytes;

var DEBOUNCE_TIME = 500;

var SensorParams = React.createClass({
	propTypes : {
		
	},

	getInitialState: function() {
		return {
			
		}
	},

	componentDidMount: function() {
		SensorStore.addFlashWrittenListener(this._flashWrittenHandler);
		SensorStore.addFlashReadListener(this._flashReadHandler);
	},

	componentWillUnmount: function() {
		SensorStore.removeFlashWrittenListener(this._flashWrittenHandler);
		SensorStore.removeFlashReadListener(this._flashReadHandler);
	},

	
	_flashWrittenHandler : function() {
		alertify.success('FLASH written');
	},

	_flashReadHandler : function(data) {
		alertify.success('FLASH read');
	},

	_load : function (event) {
		SensorActions.flashToRam();
	},

	_save : function (event) {
		SensorActions.ramToFlash();
	},

	render: function() {
		return (
			<div className='ui buttons eeprom'>
				<div
					className='ui button'
					onClick={this._save}
				>Save current settings</div>
				<div
					className='ui button'
					onClick={this._load}
				>Load settings</div>
			</div>
	    );
	}

});

module.exports = SensorParams;
