

var React = require('react');
var ReactDOM = require('react-dom');
var SensorActions = require('../actions/SensorActions');
var SensorStore = require('../stores/SensorStore');
var AppConfig = require('../objects/AppConfig');
var ConnectionTypeConstants = require('../constants/ConnectionTypeConstants');

var classNames = require('classnames');
var ping = nw.require('ping');

// refresh com ports
var SerialPort = nw.require("serialport");
var portRefreshTimer;


var Connection = React.createClass({
	getInitialState: function() {
		return {
			ip   : AppConfig.getIp(),
			port : AppConfig.getPort(),

			comPort :  AppConfig.getComPort(),
			portsList : [],


			type : AppConfig.getConnectionType(),

			connected : false,
			connecting : false,

			fwVersion : ''
		};
	},
	
	componentDidMount: function() {
		SensorStore.addFwVersionListener(this._fwVersionWasReadHandler);
		SensorStore.addSensorConnectedListener(this._connectedChangedHandler);
		SensorStore.addSensorDisconnectedListener(this._disconnectedChangedHandler);
		
		portRefreshTimer = setInterval(function () {
			SerialPort.list(function (err, ports) {
				if (!err) {
					//if preselected comport in component state is not in list, select first comport
					if (!ports.some((port) => {
						return port.comName === this.state.comPort;
					})){
						var newPortState = '';
						if (ports.length){
							newPortState = ports[0].comName;
						}
						this.setState({
							comPort : newPortState
						});
					}

					var list = [];
					ports.forEach(function (value) {
						list.push(
							<option key={value.comName} value={value.comName}>{value.comName}</option>
						)
					});
						
					this.setState({
						portsList : list
					});
				}
			}.bind(this));					
		}.bind(this), 1000);
	},
	
	componentWillUnmount: function() {
		SensorStore.removeFwVersionListener(this._fwVersionWasReadHandler);
		SensorStore.removeSensorConnectedListener(this._connectedChangedHandler);
		SensorStore.removeSensorDisconnectedListener(this._disconnectedChangedHandler);
		
		clearInterval(portRefreshTimer);
	},

	_fwVersionWasReadHandler : function (data) {
		this.setState({
			fwVersion : data
		});
	},

	_connectedChangedHandler : function (connectionInfo) {
		this.setState({
			connected : true,
			connecting : false
		});	
	},

	_disconnectedChangedHandler : function () {
		this.setState({
			connected : false,
			connecting : false
		});	
	},
	
	_connectButtonClick: function(event) {
		// if already connecting action - do nothing
		if (!this.state.connecting) {
			//if not connected - set connecting state and connect right type of connection
			if (!this.state.connected) {
				this.setState({
					connecting : true
				},
				function() {
					switch (this.state.type){
						case ConnectionTypeConstants.ETHERNET:
							this._connectEthernet();
							break;
						case ConnectionTypeConstants.USB:
							this._connectUsb();
							break;
						case ConnectionTypeConstants.SERIAL:
							this._connectSerial();
							break;
					}
				}.bind(this));
			}else{
				SensorActions.disconnect();
			}
		}
	},

	_connectEthernet : function () {
		//try to ping the address first			
		ping.promise.probe(this.state.ip, {
			timeout: 500
		}).then(function (res) {
			//if alive, try to connect
			if (res.alive) {
				SensorActions.connectEthernet({
					ip   : this.state.ip,
					port : this.state.port
				});
			}else{
				this.setState({
					connecting : false
				});
			}
		}.bind(this));
	},

	_connectUsb : function () {
		SensorActions.connectUsb();
	},

	_connectSerial : function () {
		if (this.state.comPort){
			SensorActions.connectSerial(this.state.comPort);
		}else{
			this.setState({
				connecting : false
			});
		}
	},

	_onIpKeyUp: function (event) {
		if (event.keyCode === 13){
			this._connectButtonClick();
		}
	},

	_ipChange: function(event){
		this.setState({
			ip : event.target.value
		});
		AppConfig.setIp(event.target.value);
	},

	_searchedIpSelected : function (ip) {
		this.setState({
			ip : ip
		});
		AppConfig.setIp(ip);	
	},

	_portChange: function(event){
		this.setState({
			port : parseInt(event.target.value)
		});
		AppConfig.setPort(event.target.value);
	},

	_comPortChange: function(event){
		this.setState({
			comPort : event.target.value
		});
		AppConfig.setComPort(event.target.value);
	},

	_typeChange : function (event) {
		this.setState({
			type : event.target.value
		});
		AppConfig.setConnectionType(event.target.value);
	},

	_powerOffButtonClick : function(){
		SensorActions.powerOff();
	},
	
	setConnectionType : function (connType) {
		this.setState({
			type : connType
		}, function(){
			AppConfig.setConnectionType(connType);
		});	
	},

	setIp : function (ip) {
		this.setState({
			ip : ip
		}, function(){
			AppConfig.setIp(ip);
		});	
	},

	render: function() {
		var connectButtonClasses = classNames(
			'ui fluid button',
			{
				'green' : !this.state.connected,
				'loading' : this.state.connecting,
				'red' : this.state.connected
			}
		);
		var connectButtonText = this.state.connected ? 'Disconnect' : 'Connect';
		var powerOffButtonClasses = classNames(
			'ui fluid button',
			{
				'disabled' : !this.state.connected
			}
		);
		
		return (
			<div>
				<h3>Connection</h3>
				<div className="ui fluid form">
					<div className="fields">
						{/*<div className="three wide field" >
							<select
								id="port"
								ref="port"
								value={this.state.type}
								onChange={this._typeChange}
								disabled={this.state.connected || this.state.connecting}
							>
								<option value={ConnectionTypeConstants.ETHERNET}>{ConnectionTypeConstants.ETHERNET}</option>
								<option value={ConnectionTypeConstants.USB}>{ConnectionTypeConstants.USB}</option>
								<option value={ConnectionTypeConstants.SERIAL}>{ConnectionTypeConstants.SERIAL}</option>
							</select>
						</div>*/}
						<div className={"five wide field " + ((this.state.type !== ConnectionTypeConstants.ETHERNET) ? 'hidden' : '')} >
							<input
								type="text"
								id="ip"
								placeholder="IP address"
								value={this.state.ip}
								onChange={this._ipChange}
								onKeyUp={this._onIpKeyUp}
								disabled={this.state.connected || this.state.connecting}
							/>
						</div>
						<div className={"three wide field " + ((this.state.type !== ConnectionTypeConstants.ETHERNET) ? 'hidden' : '')} >
							<select
								id="port"
								ref="port"
								value={this.state.port}
								onChange={this._portChange}
								disabled={this.state.connected || this.state.connecting}
							>
								<option value="1024">Active</option>
								<option value="1028">Monitor</option>
							</select>
						</div>
						<div className={"eight wide field " + ((this.state.type !== ConnectionTypeConstants.SERIAL) ? 'hidden' : '')} >
							<select onChange={this._comPortChange} value={this.state.comPort}>
								{this.state.portsList}
							</select>
						</div>
						<div className="four wide field">
							<button
								id="connect"
								type="button"
								className={connectButtonClasses}
								onClick={this._connectButtonClick}
							>
								{connectButtonText}
							</button>
						</div>
						{
							/* power off jen pro svn version vetsi nez 2419 */
							(this.state.fwVersion && (this.state.fwVersion.svnRevision >= 2419)) ? <div className="four wide field">
									<button
										id="powerOff"
										type="button"
										className={powerOffButtonClasses}
										onClick={this._powerOffButtonClick}
									>
										Power off
									</button>
								</div>
							:
								null
						}						
					</div>
				</div>
			</div>
	    );
	}

});

module.exports = Connection;