
var AppDispatcher = require('../dispatcher/AppDispatcher');
var SensorActionConstants = require('../constants/SensorActionConstants');

var SensorActions = {
	/**
	 * Get params
	 */
	getSensorParams: function() {
		AppDispatcher.dispatch({
			actionType: SensorActionConstants.GET_SENSOR_PARAMS
		});
	},


	/**
	 * @param  {number} value
	 */
	thresholdChange: function(value) {
		AppDispatcher.dispatch({
			actionType: SensorActionConstants.THRESHOLD_CHANGE,
			value: value
		});
	},


	modeChange: function(value) {
		AppDispatcher.dispatch({
			actionType: SensorActionConstants.MODE_CHANGE,
			value: value
		});
	},

	
	// connectEthernet: function(config) {
	// 	AppDispatcher.dispatch({
	// 		actionType: SensorActionConstants.CONNECT_ETHERNET,
	// 		value : config
	// 	});
	// },

	// connectUsb: function(config) {
	// 	AppDispatcher.dispatch({
	// 		actionType: SensorActionConstants.CONNECT_USB
	// 	});
	// },

	/**
	 */
	connectSerial: function(comPort) {
		AppDispatcher.dispatch({
			actionType: SensorActionConstants.CONNECT_SERIAL,
			value: comPort
		});
	},

	/**
	 * Write in eeprom bank
	 * @param  {object} value 
	 * {
	 *		config : instance of SensorConfig
	 *	}
	 */
	ramToFlash: function(value) {
		AppDispatcher.dispatch({
			actionType: SensorActionConstants.RAM_TO_FLASH,
			value : value
		});
	},

	/**
	 * Read eeprom bank
	 */
	flashToRam: function(value) {
		AppDispatcher.dispatch({
			actionType: SensorActionConstants.FLASH_TO_RAM,
			value : value
		});
	},

	/**
	 * Read eeprom bank
	 */
	// ethernetConfigWrite: function(value) {
	// 	AppDispatcher.dispatch({
	// 		actionType: SensorActionConstants.ETHERNET_CONFIG_WRITE,
	// 		value : value
	// 	});
	// },

	/**
	 * Read eeprom bank
	 */
	// ethernetConfigRead: function() {
	// 	AppDispatcher.dispatch({
	// 		actionType: SensorActionConstants.ETHERNET_CONFIG_READ
	// 	});
	// },
	
	tableSaveItem: function () {
		AppDispatcher.dispatch({
			actionType: SensorActionConstants.TABLE_SAVE_ITEM
		});
	},

	tableDeleteItem: function (index) {
		AppDispatcher.dispatch({
			actionType: SensorActionConstants.TABLE_DELETE_ITEM,
			value : index
		});
	},

	tableDeleteAll: function () {
		AppDispatcher.dispatch({
			actionType: SensorActionConstants.TABLE_DELETE_ALL
		});
	},

	normalize: function() {
		AppDispatcher.dispatch({
			actionType: SensorActionConstants.NORMALIZE
		});
	},

	disconnect: function() {
		AppDispatcher.dispatch({
			actionType: SensorActionConstants.DISCONNECT
		});
	},

	streamAvgStart: function() {
		AppDispatcher.dispatch({
			actionType: SensorActionConstants.STREAM_AVG_START
		});
	},

	streamAvgNoDataStart: function() {
		AppDispatcher.dispatch({
			actionType: SensorActionConstants.STREAM_AVG_NO_DATA_START
		});
	},

	streamStop: function() {
		AppDispatcher.dispatch({
			actionType: SensorActionConstants.STREAM_STOP
		});
	},

	powerOff: function() {
		AppDispatcher.dispatch({
			actionType: SensorActionConstants.POWER_OFF
		});
	},

};

module.exports = SensorActions;
