
var AppDispatcher = require('../dispatcher/AppDispatcher');
var AppActionConstants = require('../constants/AppActionConstants');

var AppActions = {
	/**
	 * @param  {array of boolean} Four booleans representing point visibility
	 */
	displayedPointsChange: function(points) {
		AppDispatcher.dispatch({
			actionType: AppActionConstants.DISPLAYED_POINTS_CHANGE,
			value: points
		});
	},
	
	/**
	 * @param  {string} tab Name of the changed tab
	 */
	tabChange: function(tab) {
		AppDispatcher.dispatch({
			actionType: AppActionConstants.TAB_CHANGE,
			value: tab
		});
	}

};

module.exports = AppActions;
